jQuery(function($) {
    var ids = [];
    var current = 0;
    var total = 0;
    var running = false;

    function logLine(msg) {
        $('#caai-meta-log').prepend('<li>' + msg + '</li>');
    }

    function updateProgress() {
        if (!total) return;
        var percent = Math.round((current / total) * 100);
        $('#caai-meta-progress-bar-inner').css('width', percent + '%');
        $('#caai-meta-progress-text').text('Processed ' + current + ' of ' + total + ' items (' + percent + '%).');
    }

    function runNext() {
        if (!running) return;
        if (current >= total) {
            updateProgress();
            logLine('All done.');
            $('#caai-meta-progress-text').text('Completed all meta description updates.');
            running = false;
            return;
        }

        var postId = ids[current];

        $.post(
            CAAI_Meta.ajax_url,
            {
                action: 'caai_meta_generate_for_post',
                nonce: CAAI_Meta.nonce,
                post_id: postId
            }
        ).done(function(resp) {
            if (!resp || !resp.success) {
                var msg = 'Error for post ID ' + postId + ': ';
                if (resp && resp.data && resp.data.message) {
                    msg += resp.data.message;
                } else {
                    msg += 'Unknown error.';
                }
                logLine(msg);
            } else {
                var d = resp.data || {};
                var msg2 = 'Updated [' + d.post_id + '] ' + (d.title || '') + ' → ' + (d.description || '');
                logLine(msg2);
            }
            current++;
            updateProgress();
            setTimeout(runNext, 5000);
        }).fail(function() {
            logLine('AJAX error for post ID ' + postId + '. Skipping.');
            current++;
            updateProgress();
            setTimeout(runNext, 5000);
        });
    }

    $('#caai-meta-start').on('click', function(e) {
        e.preventDefault();

        if (running) {
            return;
        }

        if (!confirm('Have you added your OpenAI API key and taken a recent database backup? This will overwrite existing Yoast meta descriptions.')) {
            return;
        }

        running = true;
        ids = [];
        current = 0;
        total = 0;

        $('#caai-meta-progress-wrapper').show();
        $('#caai-meta-log').empty();
        $('#caai-meta-progress-bar-inner').css('width', '0%');
        $('#caai-meta-progress-text').text('Scanning content…');

        $.post(
            CAAI_Meta.ajax_url,
            {
                action: 'caai_meta_get_targets',
                nonce: CAAI_Meta.nonce
            }
        ).done(function(resp) {
            if (!resp || !resp.success || !resp.data || !resp.data.ids) {
                running = false;
                var msg = 'Could not retrieve target posts. ';
                if (resp && resp.data && resp.data.message) {
                    msg += resp.data.message;
                }
                logLine(msg);
                $('#caai-meta-progress-text').text('Failed to prepare targets.');
                return;
            }

            ids = resp.data.ids;
            total = ids.length || 0;

            if (!total) {
                running = false;
                logLine('No posts/pages found for the selected post types.');
                $('#caai-meta-progress-text').text('No items to process.');
                return;
            }

            logLine('Found ' + total + ' items. Starting generation…');
            updateProgress();
            runNext();
        }).fail(function() {
            running = false;
            logLine('AJAX error while fetching target posts.');
            $('#caai-meta-progress-text').text('Failed to prepare targets.');
        });
    });
});
